/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.lopymine.mtd.cache.CachedSkinsManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.sub.HandRenderingConfig;
import net.lopymine.mtd.config.sub.RenderingConfig;
import net.lopymine.mtd.doll.layer.DollLayers;
import net.lopymine.mtd.doll.model.DollModel;
import net.lopymine.mtd.doll.tag.DollTagManager;
import net.lopymine.mtd.utils.SkinTextures;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DollRenderer {
    private static final float TEST = 0.0f;

    public static void renderFloatingDoll(class_4587 matrices, class_5599 modelLoader, class_1799 stack, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        class_3545<String, SkinTextures> skinTextures = DollRenderer.parseSkinTextures(stack);
        DollModel dollModel = DollRenderer.bakeDoll(modelLoader, (SkinTextures)skinTextures.method_15441());
        DollRenderer.renderAsFloating(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
        matrices.method_22909();
    }

    public static void renderDoll(class_4587 matrices, class_5599 entityModelLoader, class_1799 stack, class_811 renderMode, boolean leftHanded, class_4597 vertexConsumers, int light, int overlay, class_1087 model) {
        matrices.method_22903();
        class_804 transformation = model.method_4709().method_3503(renderMode);
        transformation.method_23075(leftHanded, matrices);
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        class_3545<String, SkinTextures> skinTextures = DollRenderer.parseSkinTextures(stack);
        DollModel dollModel = DollRenderer.bakeDoll(entityModelLoader, (SkinTextures)skinTextures.method_15441());
        switch (renderMode) {
            case field_4317: {
                DollRenderer.renderInGui(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4316: {
                DollRenderer.renderInHead(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4319: {
                DollRenderer.renderFixed(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4318: {
                DollRenderer.renderOnGround(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4321: {
                DollRenderer.renderInHand(true, true, matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4322: {
                DollRenderer.renderInHand(false, true, matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4323: {
                DollRenderer.renderInHand(true, false, matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4320: {
                DollRenderer.renderInHand(false, false, matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
                break;
            }
            case field_4315: {
                DollRenderer.render(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
            }
        }
        matrices.method_22909();
    }

    private static void renderInHand(boolean leftHanded, boolean firstPerson, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        if (firstPerson) {
            float xOffset = 1.75f;
            float yOffset = 0.3f;
            float zOffset = -1.7f;
            float zRotation = 20.0f;
            MyTotemDollConfig config = MyTotemDollClient.getConfig();
            RenderingConfig renderingConfig = config.getRenderingConfig();
            HandRenderingConfig handRenderingConfig = leftHanded ? renderingConfig.getLeftHandConfig() : renderingConfig.getRightHandConfig();
            matrices.method_22903();
            matrices.method_46416(leftHanded ? xOffset : -xOffset, yOffset, zOffset);
            matrices.method_22904(handRenderingConfig.getOffsetZ() / 100.0 * (double)(leftHanded ? 1 : -1), handRenderingConfig.getOffsetY() / 100.0, handRenderingConfig.getOffsetX() / 100.0);
            matrices.method_46416(0.5f, 0.35f, 0.5f);
            matrices.method_22907(class_7833.field_40717.rotationDegrees(leftHanded ? -zRotation : zRotation));
            double scale = handRenderingConfig.getScale();
            matrices.method_22905((float)scale, (float)scale, (float)scale);
            matrices.method_22907(class_7833.field_40714.rotationDegrees((float)handRenderingConfig.getRotationX()));
            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)handRenderingConfig.getRotationY() * (float)(leftHanded ? -1 : 1)));
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)handRenderingConfig.getRotationZ() * (float)(leftHanded ? -1 : 1)));
            matrices.method_46416(-0.5f, -0.35f, -0.5f);
        } else {
            float xOffset = 0.18f;
            float yOffset = 0.35f;
            float zOffset = 0.25f;
            matrices.method_22903();
            matrices.method_46416(xOffset, yOffset, zOffset);
            matrices.method_22905(0.65f, 0.65f, 0.65f);
        }
        DollRenderer.render(matrices, vertexConsumers, light, overlay, model, skinTextures);
        matrices.method_22909();
    }

    private static void renderOnGround(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        matrices.method_22903();
        matrices.method_46416(0.1f, 0.2f, 0.85f);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
        matrices.method_22905(0.7f, 0.7f, 0.7f);
        DollRenderer.render(matrices, vertexConsumers, light, overlay, model, skinTextures);
        matrices.method_22909();
    }

    private static void renderFixed(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 0.8f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_46416(0.0f, 0.0f, -1.2f);
        model.getCape().field_3654 = 0.2f;
        DollRenderer.render(matrices, vertexConsumers, light, overlay, model, skinTextures);
        matrices.method_22909();
    }

    public static void renderInHead(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, -0.2f);
        DollRenderer.render(matrices, vertexConsumers, light, overlay, model, skinTextures);
        matrices.method_22909();
    }

    private static void renderInGui(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        Vector3f vec = new Vector3f(0.0f, 1.0f, 1.0f).normalize();
        Vector3f vec2 = new Vector3f(0.0f, 1.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)vec, (Vector3f)vec2);
        matrices.method_22903();
        float yOffset = ((SkinTextures)skinTextures.method_15441()).capeTexture() != null ? 0.37f : 0.3f;
        float xOffset = 0.25f;
        String nickname = (String)skinTextures.method_15442();
        if (nickname != null && nickname.equals("deadmau5")) {
            yOffset = 0.2f;
            xOffset = 0.3f;
        }
        matrices.method_46416(xOffset, yOffset, 0.25f);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(20.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(10.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(20.0f));
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_46416(-0.1f, -yOffset, -0.25f);
        DollRenderer.render(matrices, vertexConsumers, light, overlay, model, skinTextures);
        matrices.method_22909();
    }

    private static void renderAsFloating(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel dollModel, class_3545<String, SkinTextures> skinTextures) {
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        matrices.method_22905(0.8f, 0.8f, 0.8f);
        matrices.method_46416(0.1f, 0.0f, 0.0f);
        DollRenderer.render(matrices, vertexConsumers, light, overlay, dollModel, skinTextures);
        matrices.method_22909();
    }

    private static void render(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, DollModel model, class_3545<String, SkinTextures> skinTextures) {
        class_2960 capeTexture;
        SkinTextures textures = (SkinTextures)skinTextures.method_15441();
        String nickname = (String)skinTextures.method_15442();
        if (nickname != null && (nickname.equals("dinnerbone") || nickname.equals("grumm"))) {
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        matrices.method_22905(1.0f, -1.0f, -1.0f);
        class_4588 skinVertexConsumer = vertexConsumers.getBuffer(model.method_23500(textures.texture()));
        model.method_2828(matrices, skinVertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (nickname != null && nickname.equals("deadmau5")) {
            model.renderEars(matrices, skinVertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if ((capeTexture = textures.capeTexture()) != null) {
            class_4588 capeVertexConsumer = vertexConsumers.getBuffer(model.method_23500(capeTexture));
            model.renderCape(matrices, capeVertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.method_22909();
    }

    private static class_3545<@Nullable String, @NotNull SkinTextures> parseSkinTextures(class_1799 stack) {
        class_2561 customName;
        class_2561 class_25612 = customName = stack.method_7938() ? stack.method_7964() : null;
        if (customName != null) {
            String nickname = DollTagManager.getOnlyNickname(customName.getString());
            return new class_3545((Object)nickname, (Object)CachedSkinsManager.getSkin(nickname));
        }
        return new class_3545(null, (Object)CachedSkinsManager.DEFAULT_DOLL_TEXTURES);
    }

    private static DollModel bakeDoll(class_5599 modelLoader, SkinTextures skinTextures) {
        class_5601 layer = skinTextures.model() == SkinTextures.Model.WIDE ? DollLayers.STEVE_MODEL_LAYER : DollLayers.ALEX_MODEL_LAYER;
        class_630 modelPart = modelLoader.method_32072(layer);
        return new DollModel(modelPart);
    }
}

